

// defines
#define THIS_IS_STACK_APPLICATION

// Includes
#include "TCPIP Stack/TCPIP.h"
#include "MainDemo.h"
#include "USB/usb.h"
#include "USB/usb_host_msd.h"
#include "USB/usb_host_msd_scsi.h"
#include "MDD File System/FSIO.h"
#include "GenericTypeDefs.h"


#include "spiflash.h"



//char debugSave[2000];


BYTE currentLcdColor = 0;
//externs
extern void  WF_Connect(void);
extern int thumbsavenumber;
extern void SPIFlashWrite(BYTE ,BOOL);
extern void LcdPrintString (BYTE *);//BOB
extern void PrintControl(void);
extern void Tick2Init(void);
extern void LCDinit(void);
extern unsigned long get_three;
extern volatile unsigned int  OneMs;
extern char LcdBuf[];
extern void LCDInit(void);
extern int TenMs;
extern void Tick2Init(void);
extern int Get_Ade_Reg( unsigned int);
extern void InitADE7758(void);
extern void OpenSPI3(void);
extern void I2Cinit(void);
extern void PrintControl(void);
extern char LCDText[];
extern int sample;
extern int Previous_Event;
extern int Cur_Event;
extern unsigned int Int_A;
extern unsigned int Int_B;
extern unsigned int Int_C;
extern unsigned long Long_Int_A;
extern unsigned long Long_Int_B;
extern unsigned long Long_Int_C;
extern double Aamp_LSB;
extern double Bamp_LSB;
extern double Camp_LSB;
extern int int_event;
void SaveAccumWattsToFlash(void);
void initPowerReadings(void);
extern void inititalizePowerChip(void);
extern  unsigned int crc;
extern int Get_Two_Reg( unsigned int);
extern BOOL convertAsciiToHexInPlace( INT8 , UINT8  );
extern volatile int areg;  
extern volatile int breg; 
extern volatile int creg; 
extern volatile int accum_areg;  
extern volatile int accum_breg; 
extern volatile int accum_creg;
extern volatile long number_of_seconds;
extern void Put_Three_Reg(int,long);
extern void I2Cinit(void);
extern void ADE7758_Init(void);
extern void crc_init(void);
extern double wh_lsb;
//extern BYTE Block_Busy_Byte; 
extern DWORD dwWriteAddr;
extern void crc_calc(unsigned char);
extern void Clear_lcd(void);
extern  void Print_Line_One(BYTE *);
extern  void Print_Line_Two(BYTE *);
extern  void LCDinit_two_line();
extern  void LCDinit_one_line();
extern long Get_Three_Reg(int);
extern double Avolt_lsb;
extern double Bvolt_lsb;				
extern double Cvolt_lsb;   
extern double ALLamp_lsb;        
void LCDPrintIP(IP_ADDR);
void CSV_CONVERSION(POWER_READINGS *,CSV_STRUCTURE *);

int get_stored_power_readings(void);
void WF_Connect(void);
void convertAsciiWPAKeyToHex(char *);
void ClearFlash(DWORD,DWORD);
void SavePowerReadings(void);
void SaveAppConfig(void);
void FindStartingAccumValue();
int  Find_last_kwh_record (void);

void calculate_Power_Reading_CRC(BYTE* , WORD);
void Init_PowerRead(void);
void Display_Mode(int,POWER_READINGS * );
void PadBuffer (WORD , BYTE *);
void Save_to_thumb_drive(void);
void lcdColor(BYTE);
void SavePowerReadingOnFlash(void);
void getWpaPskKeyFromPassphrase(char * , char * );
void stringtowords(DWORD *,char *,DWORD); 
void initsha(DWORD * , DWORD * ,long ); 
// Variables 
float powerConsumed = 0;
int Display_mode=0;
BOOL WriteFlashToThumbDrive(void);
POWER_READINGS PowerReadings;
double Accum_A_Reg;
double Accum_B_Reg;
double Accum_C_Reg;
BYTE HexWPAKey[32];
char debugBuf[20];
int connLostCounter =0;//bob
volatile BOOL deviceAttached;
volatile BOOL MemInterfaceAttached = FALSE;
char time_str[25];
// BYTE FSerrno; // BOB 1-31-2013
int line_mode =0; //1 for 2 lines 0 for one line
char Activity_log[20];
static void InitAppConfig(void);
static void InitializeBoard(void);
int powerSaveCounter = 0;
static void MonitorMedia( void );
static DWORD dwLastIP = 0;
static BOOL ssidFileReadComplete = FALSE;
BOOL SavePowerReadingOnThumbDrive(POWER_READINGS *);

BOOL lastSaveToThumbDrive = TRUE; //this switch tells whether the last time through the thumbdrive worked..if not, then there is data in the flash
									//that must be written.
BOOL LoopCount = 0;
BOOL AccumPowerIsNotRestored = TRUE;
BYTE AN0String[8];
DWORD Kwh_Address;
BOOL GetSSIDFile(void); //bob
DWORD tick_save;
DWORD sec_temp;
DWORD Flash_Address;
BOOL GetCALFile(void);
APP_CONFIG AppConfig;
DWORD StackStartTime = 0;
INT64 gCumulativePower[3] = {0,0,0};
BYTE ledBits;
tWFScanResult  p_scanRes;
UINT8 numberOfNetworks;
BOOL FileSysInitLock=FALSE;
BOOL EncryptionInProgress = FALSE;
CALIBRATION_STRUCTURE CalValues;
BYTE RED  = 6;
BYTE BLUE  = 5;
BYTE GREEN  = 3;
BYTE YELLOW  = 1;
BYTE WHITE  = 0;
DWORD saveAccumAreaStart = 0x4000;
DWORD saveAccumAreaEnd =  0x32000;
DWORD savePowerAreaStart= 0x40000;
DWORD savePowerAreaEnd  = 0x80000;
BOOL Cal_Loaded = FALSE;


int TimeZoneToUTCConvert[12] = {0,12600,14400,18000,21600,25200,28800,32400,36000};




typedef struct 
{
    union
    {
        BYTE    value;
        struct
        {
            BYTE        mediaPresent            : 1;
            BYTE        cannotInitialize        : 1;
            BYTE        overcurrentStateUSB     : 1;
        };
    };
} MEDIA_STATUS;

MEDIA_STATUS mediaStatus;




// Use UART2 instead of UART1 for stdout (printf functions).  Explorer 16 
// serial port hardware is on PIC UART


void __attribute__((address(0x8404))) _InterruptRemapping() // bob 0x7804
{ 
   	asm("goto __DefaultInterrupt"); 	//reserved 
   	asm("goto __OscillatorFail");  		//OscillatorFail 
   	asm("goto __AddressError");  		//AddressError
   	asm("goto __StackError");  			//StackError 
   	asm("goto __MathError");  			//MathError
	asm("goto __DefaultInterrupt");  	//ReservedTrap5 not implemented
   	asm("goto __DefaultInterrupt");  	//ReservedTrap6 not implemented 
   	asm("goto __DefaultInterrupt");  	//ReservedTrap7 not implemented 
   	asm("goto __DefaultInterrupt");  	//interrupt 0 
   	asm("goto __DefaultInterrupt");  	//interrupt 1 
   	asm("goto __DefaultInterrupt");  	//interrupt 2 
   	asm("goto __T1Interrupt");  		//interrupt 3 
	asm("goto __DefaultInterrupt");  	//interrupt 4
   	asm("goto __DefaultInterrupt");  	//interrupt 5  
   	asm("goto __DefaultInterrupt");  	//interrupt 6  
   	asm("goto __T2Interrupt");  		//interrupt 7  
   	asm("goto __DefaultInterrupt"); 	//interrupt 8  
   	asm("goto __DefaultInterrupt");  	//interrupt 9  
   	asm("goto __DefaultInterrupt");  	//interrupt 10 
   	asm("goto __DefaultInterrupt");  	//interrupt 11
   	asm("goto __DefaultInterrupt");  	//interrupt 12 
   	asm("goto __DefaultInterrupt");  	//interrupt 13
	asm("goto __DefaultInterrupt");  	//interrupt 14
	asm("goto __DefaultInterrupt");  	//interrupt 15    
   	asm("goto __DefaultInterrupt");  	//interrupt 16 
   	asm("goto __DefaultInterrupt");  	//interrupt 17 
   	asm("goto __DefaultInterrupt");  	//interrupt 18  
   	asm("goto __DefaultInterrupt");  	//interrupt 19 
   	asm("goto __INT1Interrupt");  		//interrupt 20 
	asm("goto __DefaultInterrupt");  	//interrupt 21 
   	asm("goto __DefaultInterrupt");  	//interrupt 22 
   	asm("goto __DefaultInterrupt");  	//interrupt 23
	asm("goto __DefaultInterrupt");  	//interrupt 24 
   	asm("goto __DefaultInterrupt");  	//interrupt 25 
   	asm("goto __DefaultInterrupt");  	//interrupt 26 
   	asm("goto __DefaultInterrupt");  	//interrupt 27 
   	asm("goto __DefaultInterrupt");  	//interrupt 28  
   	asm("goto __DefaultInterrupt");  	//interrupt 29 
   	asm("goto __DefaultInterrupt");  	//interrupt 30  
   	asm("goto __DefaultInterrupt");  	//interrupt 31 
   	asm("goto __DefaultInterrupt");  	//interrupt 32 
   	asm("goto __DefaultInterrupt");  	//interrupt 33
	asm("goto __DefaultInterrupt");  	//interrupt 34
   	asm("goto __DefaultInterrupt");  	//interrupt 35 
   	asm("goto __DefaultInterrupt");  	//interrupt 36 
   	asm("goto __DefaultInterrupt");  	//interrupt 37 
   	asm("goto __DefaultInterrupt");  	//interrupt 38 
   	asm("goto __DefaultInterrupt");  	//interrupt 39 
   	asm("goto __DefaultInterrupt");  	//interrupt 40 
   	asm("goto __DefaultInterrupt");  	//interrupt 41 
   	asm("goto __DefaultInterrupt");  	//interrupt 42 
   	asm("goto __DefaultInterrupt");  	//interrupt 43 
   	asm("goto __DefaultInterrupt");  	//interrupt 44  
   	asm("goto __DefaultInterrupt");  	//interrupt 45
	asm("goto __DefaultInterrupt");  	//interrupt 46
	asm("goto __DefaultInterrupt");  	//interrupt 47
	asm("goto __DefaultInterrupt");  	//interrupt 48
	asm("goto __DefaultInterrupt");  	//interrupt 49  
   	asm("goto __DefaultInterrupt");  	//interrupt 50 
	asm("goto __DefaultInterrupt");  	//interrupt 51
	asm("goto __DefaultInterrupt");  	//interrupt 52    
   	asm("goto __INT3Interrupt");  		//interrupt 53  
   	asm("goto __DefaultInterrupt");  	//interrupt 54
	asm("goto __DefaultInterrupt");  	//interrupt 55   
   	asm("goto __DefaultInterrupt");  	//interrupt 56  
   	asm("goto __DefaultInterrupt");  	//interrupt 57  
   	asm("goto __DefaultInterrupt");  	//interrupt 58    
   	asm("goto __DefaultInterrupt");  	//interrupt 59   
   	asm("goto __DefaultInterrupt");  	//interrupt 60    
   	asm("goto __DefaultInterrupt");  	//interrupt 61  
   	asm("goto __DefaultInterrupt");  	//interrupt 62 
	asm("goto __DefaultInterrupt");  	//interrupt 63  
   	asm("goto __DefaultInterrupt");  	//interrupt 64    
   	asm("goto __DefaultInterrupt");  	//interrupt 65  
   	asm("goto __DefaultInterrupt");  	//interrupt 66  
   	asm("goto __DefaultInterrupt");  	//interrupt 67 
	asm("goto __DefaultInterrupt");  	//interrupt 68   
   	asm("goto __DefaultInterrupt");  	//interrupt 69    
   	asm("goto __DefaultInterrupt");  	//interrupt 70  
   	asm("goto __DefaultInterrupt");  	//interrupt 71     
   	asm("goto __DefaultInterrupt");  	//interrupt 72   
   	asm("goto __DefaultInterrupt");  	//interrupt 73    
   	asm("goto __DefaultInterrupt");  	//interrupt 74
	asm("goto __DefaultInterrupt");  	//interrupt 75 
	asm("goto __DefaultInterrupt");  	//interrupt 76  
   	asm("goto __DefaultInterrupt");  	//interrupt 77    
   	asm("goto __DefaultInterrupt");  	//interrupt 78  
   	asm("goto __DefaultInterrupt");  	//interrupt 79  
   	asm("goto __DefaultInterrupt");  	//interrupt 80 
	asm("goto __DefaultInterrupt");  	//interrupt 81   
   	asm("goto __DefaultInterrupt");  	//interrupt 82  
   	asm("goto __DefaultInterrupt");  	//interrupt 83  
   	asm("goto __DefaultInterrupt");  	//interrupt 84  
   	asm("goto __DefaultInterrupt");  	//interrupt 85  
   	asm("goto __USB1Interrupt");  		//interrupt 86  
   	asm("goto __DefaultInterrupt");  	//interrupt 87  
   	asm("goto __DefaultInterrupt");  	//interrupt 88  
   	asm("goto __DefaultInterrupt");  	//interrupt 89  
   	asm("goto __DefaultInterrupt");  	//interrupt 90 
   	asm("goto __DefaultInterrupt");  	//interrupt 91 
   	asm("goto __DefaultInterrupt");  	//interrupt 92  
	asm("goto __DefaultInterrupt");  	//interrupt 93  
   	asm("goto __DefaultInterrupt");  	//interrupt 94  
   	asm("goto __DefaultInterrupt");  	//interrupt 95  
   	asm("goto __DefaultInterrupt");  	//interrupt 96 
   	asm("goto __DefaultInterrupt");  	//interrupt 97 
   	asm("goto __DefaultInterrupt");  	//interrupt 98 
	asm("goto __DefaultInterrupt");  	//interrupt 99  
   	asm("goto __DefaultInterrupt");  	//interrupt 100  
   	asm("goto __DefaultInterrupt");  	//interrupt 101 
   	asm("goto __DefaultInterrupt");  	//interrupt 102
   	asm("goto __DefaultInterrupt");  	//interrupt 103
   	asm("goto __DefaultInterrupt");  	//interrupt 104
	asm("goto __DefaultInterrupt");  	//interrupt 105 
   	asm("goto __DefaultInterrupt");  	//interrupt 106
   	asm("goto __DefaultInterrupt");  	//interrupt 107 
   	asm("goto __DefaultInterrupt");  	//interrupt 108
   	asm("goto __DefaultInterrupt");  	//interrupt 109
   	asm("goto __DefaultInterrupt");  	//interrupt 110
	asm("goto __DefaultInterrupt");  	//interrupt 111
	asm("goto __DefaultInterrupt");  	//interrupt 112 
   	asm("goto __DefaultInterrupt");  	//interrupt 113
   	asm("goto __DefaultInterrupt");  	//interrupt 114 
   	asm("goto __DefaultInterrupt");  	//interrupt 115
   	asm("goto __DefaultInterrupt");  	//interrupt 116
   	asm("goto __DefaultInterrupt");  	//interrupt 117
}




	void __attribute__((interrupt, auto_psv)) _DefaultInterrupt(void)
    {

      while (1)
      {
          Nop();
          Nop();
          Nop();
		  return; 
      }
    }

    void __attribute__((interrupt, auto_psv)) _OscillatorFail(void)
    {

      while (1)
      {
          Nop();
          Nop();
          Nop();
      }
    }
    void __attribute__((interrupt, auto_psv)) _AddressError(void)
    {
      while (1)
      {
          Nop();
          Nop();
          Nop();
		  return;
      }
    }
    void __attribute__((interrupt, auto_psv)) _StackError(void)
    {

      while (1)
      {
          Nop();
          Nop();
          Nop();
      }
    }
    void __attribute__((interrupt, auto_psv)) _MathError(void)
    {

      	while (1)
    	{
          Nop();
          Nop();
          Nop();
    	}
    }


 _CONFIG2(FNOSC_PRIPLL & POSCMOD_HS & PLL_96MHZ_ON & PLLDIV_DIV2) // Primary HS OSC with PLL, USBPLL /2
 _CONFIG1(JTAGEN_OFF & FWDTEN_OFF & WDTPS_PS8192 & ICS_PGx2)   // JTAG off, watchdog timer off

#if defined( WF_CS_TRIS )
    /* used for WiFi assertions */
    #ifdef WF_DEBUG
        #define WF_MODULE_NUMBER   WF_MODULE_MAIN_DEMO
    #endif
#endif /* WF_CS_TRIS */

BYTE	Block_Busy_Byte;
POWER_READINGS saved_accum_power; 
BYTE Power_accum_saved;
	
int main(void)
{

	//memset (debugSave, 0x00, 2000);
	RCONbits.SWDTEN = 1;  // ENABLE wdt
	INT one_min =0;
	int ry;
	ry= sizeof(PowerReadings);


	line_mode = 1;
	inititalizePowerChip();		
	InitializeBoard();  //All initializations happen here
	LED1_IO = 1;
	if(RED_BUTTON_IO == 0)
	{
		DWORD a = 0x00;
		DWORD b = 0x76000;
		Print_Line_One((BYTE *)"  ERASE FLASH   ");
		ClearFlash(a,b);
		Print_Line_One((BYTE *)"  ERASE DONE   ");
		Reset();
	}

	FindStartingAccumValue(); //go get the saved accumulated Power reading
//*********************************************************************************************  Main Program Loop  *********************************************************************
while(1)
{

	asm("CLRWDT");	// Clear the WatchDog Timer

        // Get the current time from the SNTP module until
        // we get a reasonable time (which will indicate that
        // the state machine has received a valid time from
        // a time server)
  	if (StackStartTime < 1248245820)
    	StackStartTime = SNTPGetUTCSeconds();

   	MonitorMedia();
	MemInterfaceAttached = MDD_MediaDetect();//Check for SD card/USB THumb drive is attached 	
	if(RED_BUTTON_IO == 0)  // red button pushed
	{
	   	Display_mode++;
	   	if(Display_mode > 7)
	   	{
		   	Display_mode = 0;
		}
	   	
	 	while(RED_BUTTON_IO == 0)// wait until red button released
	 	{
		 	
		 		if (line_mode == 1)
        	{
	        	LCDinit_one_line();
	        	line_mode = 0;
	        }
		 	sprintf(LCDText,"MODE = %d",Display_mode );
            Print_Line_One((BYTE *)LCDText);
		 		 	
		 	
		 	LED1_IO = 0;
		}
			Clear_lcd();
			
	   		LED1_IO = 1;
	   	
	}
	



	
	
			//calibrate();  // un comment if in calibration mode	
		


  if(TickGet() - tick_save >= TICK_SECOND)   //BOB/2ul)
     {
	     	sec_temp = TickGet() - tick_save;
            tick_save = TickGet();
            PowerReadings.Watt_Load_A = areg*wh_lsb*3600;  				// cal watt load areg should contain 1 second of power used
			PowerReadings.Watt_Load_B = breg*wh_lsb*3600;  				// cal watt load breg should contain 1 second of power used
			PowerReadings.Watt_Load_C = creg*wh_lsb*3600;  				// cal watt load creg should contain 1 second of power used
			PowerReadings.Accum_Total_Watt_Hour = ((PowerReadings.Accum_A_Reg+PowerReadings.Accum_B_Reg)*wh_lsb);
			one_min++;			
			Display_Mode(Display_mode, &PowerReadings);
				
			if(MemInterfaceAttached)
			{
				if  (!Cal_Loaded)
				{ 
					if(GetCALFile())
					{
					Load_Cal_Values();
					Cal_Loaded = TRUE;
					}
					else
					{
						Cal_Loaded = TRUE;
					}

				}
				if(!ssidFileReadComplete)
				{
  				GetSSIDFile();
  				ssidFileReadComplete = TRUE;
				}
			}
			if(one_min > 60) //every minute save accumulated readins.
 			{
				SaveAccumWattsToFlash();
				one_min = 0;
			} 
			if (number_of_seconds > 300)  //5 minutes 
			{								// this is a test
											
				
				PowerReadings.UTC_time = SNTPGetUTCSeconds(); // this is a test
				crc_init();
				calculate_Power_Reading_CRC((BYTE *)&PowerReadings,sizeof(PowerReadings));
				PowerReadings.CRC = crc;
				number_of_seconds =0;
				sprintf(Activity_log,"Flash save%6lX",Kwh_Address);	// update activity log
				if(!SavePowerReadingOnThumbDrive(&PowerReadings)) //if you can't save it on the thumb drive		
	 				lcdColor(RED);
				else
					lcdColor(WHITE);
					 
			}
			if(WFisConnected())	
			{	
		 		 connLostCounter = 0;
				 if(currentLcdColor == YELLOW)
				 	lcdColor(WHITE);
			}	
			else
			{
				sprintf(Activity_log,"connLostCounter=%d",connLostCounter);	  // update activity log
		 		connLostCounter++;
				if(currentLcdColor == WHITE)
				  lcdColor(YELLOW);
			}
			//if the connection is lost for 100 seconds
			//reset the device after saving the accumulated power readings			
			if(connLostCounter > 76)
			{
				//save accumulated power readings here before resetting
				StackInit();
        		WF_Connect();	//reset wifi connection
				connLostCounter = 0;
			}
			

     }
	
   	StackTask();

        // This tasks invokes each of the core stack application tasks
   	StackApplications();

   		// Process application specific tasks here.
		// For this demo app, this will include the Generic TCP 
		// client and servers, and the SNMP, Ping, and SNMP Trap
		// demos.  Following that, we will process any IO from
		// the inputs on the board itself.
		// Any custom modules or processing you need to do should
		// go here.

        // If the local IP address has changed (ex: due to DHCP lease change)
        // write the new IP address to the LCD display, UART, and Announce 
        // service
        
      
		if(dwLastIP != AppConfig.MyIPAddr.Val)
		{
			dwLastIP = AppConfig.MyIPAddr.Val;
			
			DisplayIPValue(AppConfig.MyIPAddr);

			#if defined(STACK_USE_ANNOUNCE)
				AnnounceIP();
			#endif

            #if defined(STACK_USE_ZEROCONF_MDNS_SD)
				mDNSFillHostRecord();
			#endif
		}
	
	}
}

//*******************************************************************************************************End Main Loop ***********************************************************************************************


// Writes an IP address to the LCD display and the UART as available
void DisplayIPValue(IP_ADDR IPVal)
{
//	printf("%u.%u.%u.%u", IPVal.v[0], IPVal.v[1], IPVal.v[2], IPVal.v[3]);
    BYTE IPDigit[4];
	BYTE i;
	BYTE j;
	BYTE LCDPos=0;
	for(i = 0; i < sizeof(IP_ADDR); i++)
	{
	    uitoa((WORD)IPVal.v[i], IPDigit);

		for(j = 0; j < strlen((char*)IPDigit); j++)
		{
				LCDText[LCDPos++] = IPDigit[j];
		}
		if(i == sizeof(IP_ADDR)-1)
				break;
		LCDText[LCDPos++] = '.';  
	}
	LCDText[(LCDPos++)] = 0;
	LcdPrintString((BYTE *)&LCDText);  //bob
}



/****************************************************************************
  Function:
    static void InitializeBoard(void)

  Description:
    This routine initializes the hardware.  It is a generic initialization
    routine for many of the Microchip development boards, using definitions
    in HardwareProfile.h to determine specific initialization.

  Precondition:
    None

  Parameters:
    None - None

  Returns:
    None

  Remarks:
    None
  ***************************************************************************/
static void InitializeBoard(void)
{	
	deviceAttached = FALSE;
 	curHTTP.endOfNetworkFlag = TRUE;
	// LEDs
	LED0_TRIS = 0;
	LED_PUT(0x00);
	//processor speed
	CLKDIVbits.RCDIV = 0;		// Set 1:1 8MHz FRC postscalar

#if defined(STACK_USE_UART)
		//UARTTX_TRIS = 0;
		//UARTRX_TRIS = 1;
		UMODE = 0x8000;			// Set UARTEN.  Note: this must be done before setting UTXEN

		USTA = 0x0400;		// UTXEN set
		#define CLOSEST_UBRG_VALUE ((GetPeripheralClock()+8ul*BAUD_RATE)/16/BAUD_RATE-1)
		#define BAUD_ACTUAL (GetPeripheralClock()/16/(CLOSEST_UBRG_VALUE+1))
		#define BAUD_ERROR ((BAUD_ACTUAL > BAUD_RATE) ? BAUD_ACTUAL-BAUD_RATE : BAUD_RATE-BAUD_ACTUAL)
		#define BAUD_ERROR_PRECENT	((BAUD_ERROR*100+BAUD_RATE/2)/BAUD_RATE)
		#if (BAUD_ERROR_PRECENT > 3)
			#warning UART frequency error is worse than 3%
		#elif (BAUD_ERROR_PRECENT > 2)
			#warning UART frequency error is worse than 2%
		#endif
	
		UBRG = CLOSEST_UBRG_VALUE;
#endif
// Programmable Pin Inputs
	RPINR20bits.SDI1R = 15;			//SDI1 = RPI0
    RPINR19bits.U2RXR = 40;			//Uart 2 RX = RP8
	RPINR0bits.INT1R = 10; 			//assign interrupt 1 to RP10
	RPINR22bits.SDI2R = 25;	    // SDI goes to RP25

	RPINR20bits.SDI1R = 15;			//SDI1 = RPI0
    RPINR1bits.INT3R = 19; 			//assign interrupt 3 to RP19 energy chip interrupt
	RPINR28bits.SDI3R = 21;	    // SDI goes to RP27

	// Outputs
	RPOR13bits.RP26R = 33; 	//RP26 = SCK1
	RPOR13bits.RP27R = 32;		//RP21 = SDO1
// Programmable Pin Outputs
	RPOR15bits.RP30R = SCK1OUT_IO; 	//RP30 = SCK1
	RPOR8bits.RP17R = SDO1_IO;		//RP15 = SDO1
	RPOR0bits.RP0R = 5;				//RP0 = Uart 2 TX
	RPOR11bits.RP23R = 10;   	// SDO to RP23 
	RPOR11bits.RP22R = 11; 	   // Clock to RP22
	
	TRISCbits.TRISC14 = 0;  //SET LCD DRIVES TO OUTPUT
	TRISCbits.TRISC13 = 0;
	TRISDbits.TRISD11 = 0;
	LED1_TRIS = 0;   // green button led
	
	
	TRISBbits.TRISB3 = 0; //condition energy cs for output
	
	TRISAbits.TRISA10 = 1; // button1 set for input
	
	
	
	LCD_RED = 0;
	LCD_GREEN = 0;
	LCD_BLUE = 0;
	
	SPIFLASH_CS_IO = 1;
	SPIFLASH_CS_TRIS = 0;

	I2Cinit();
	LCDinit();
	//LcdPrintString((BYTE *)"Flash Init");
	SPIFlashInit();
	//LcdPrintString((BYTE *)"Tick Init");
    TickInit();
	WF_CS_IO = 1;
	WF_CS_TRIS = 0;
	//LcdPrintString((BYTE *)"USB Init");
    USBInitialize(0);
	//LcdPrintString((BYTE *)"ADE7758 Init");
	ADE7758_Init();		//set up interrupts for ADE7758
	//LcdPrintString((BYTE *)"init appconfig");
	InitAppConfig();
	//LcdPrintString((BYTE *)"stack init");
    StackInit();
	//LcdPrintString((BYTE *)"Wifi Connect");
    WF_Connect();
	//LcdPrintString((BYTE *)"Done Inits");
    StackStartTime = 0;



  //bob  Get_Two_Reg(0x01); 

}

/*********************************************************************
 * Function:        void InitAppConfig(void)
 *
 * PreCondition:    MPFSInit() is already called.
 *
 * Input:           None
 *
 * Output:          Write/Read non-volatile config variables.
 *
 * Side Effects:    None
 *
 * Overview:        None
 *
 * Note:            None
 ********************************************************************/
// MAC Address Serialization using a MPLAB PM3 Programmer and 
// Serialized Quick Turn Programming (SQTP). 
// The advantage of using SQTP for programming the MAC Address is it
// allows you to auto-increment the MAC address without recompiling 
// the code for each unit.  To use SQTP, the MAC address must be fixed
// at a specific location in program memory.  Uncomment these two pragmas
// that locate the MAC address at 0x1FFF0.  Syntax below is for MPLAB C 
// Compiler for PIC18 MCUs. Syntax will vary for other compilers.
//#pragma romdata MACROM=0x1FFF0
static ROM BYTE SerializedMACAddress[6] = {MY_DEFAULT_MAC_BYTE1, MY_DEFAULT_MAC_BYTE2, MY_DEFAULT_MAC_BYTE3, MY_DEFAULT_MAC_BYTE4, MY_DEFAULT_MAC_BYTE5, MY_DEFAULT_MAC_BYTE6};
//#pragma romdata

static void InitAppConfig(void)
{
	AppConfig.Flags.bIsDHCPEnabled = TRUE;
	AppConfig.Flags.bInConfigMode = TRUE;
	
    //MAC Address
	memcpypgm2ram((void*)&AppConfig.MyMACAddr, (ROM void*)SerializedMACAddress, sizeof(AppConfig.MyMACAddr));
	
	//IP Address
	AppConfig.MyIPAddr.Val = MY_DEFAULT_IP_ADDR_BYTE1 | MY_DEFAULT_IP_ADDR_BYTE2<<8ul | MY_DEFAULT_IP_ADDR_BYTE3<<16ul | MY_DEFAULT_IP_ADDR_BYTE4<<24ul;
	AppConfig.DefaultIPAddr.Val = AppConfig.MyIPAddr.Val;
	
	//IP Mask Address
	AppConfig.MyMask.Val = MY_DEFAULT_MASK_BYTE1 | MY_DEFAULT_MASK_BYTE2<<8ul | MY_DEFAULT_MASK_BYTE3<<16ul | MY_DEFAULT_MASK_BYTE4<<24ul;
	AppConfig.DefaultMask.Val = AppConfig.MyMask.Val;
	
	//IP Gateway Address
	AppConfig.MyGateway.Val = MY_DEFAULT_GATE_BYTE1 | MY_DEFAULT_GATE_BYTE2<<8ul | MY_DEFAULT_GATE_BYTE3<<16ul | MY_DEFAULT_GATE_BYTE4<<24ul;
	
	//DNS Server
	AppConfig.PrimaryDNSServer.Val = MY_DEFAULT_PRIMARY_DNS_BYTE1 | MY_DEFAULT_PRIMARY_DNS_BYTE2<<8ul  | MY_DEFAULT_PRIMARY_DNS_BYTE3<<16ul  | MY_DEFAULT_PRIMARY_DNS_BYTE4<<24ul;
	AppConfig.SecondaryDNSServer.Val = MY_DEFAULT_SECONDARY_DNS_BYTE1 | MY_DEFAULT_SECONDARY_DNS_BYTE2<<8ul  | MY_DEFAULT_SECONDARY_DNS_BYTE3<<16ul  | MY_DEFAULT_SECONDARY_DNS_BYTE4<<24ul;
	
	//NETBIOS Name
	memcpypgm2ram(AppConfig.NetBIOSName, (ROM void*)MY_DEFAULT_HOST_NAME,sizeof(MY_DEFAULT_HOST_NAME));
	FormatNetBIOSName(AppConfig.NetBIOSName);
	
	//SSID
	WF_ASSERT(sizeof(MY_DEFAULT_SSID_NAME) <= sizeof(AppConfig.MySSID));
	memcpypgm2ram(AppConfig.MySSID, (ROM void*)MY_DEFAULT_SSID_NAME, sizeof(MY_DEFAULT_SSID_NAME));
	AppConfig.SsidLength = sizeof(MY_DEFAULT_SSID_NAME) - 1;
    
	//Network Type
	AppConfig.networkType = MY_DEFAULT_NETWORK_TYPE;
 
	//Security
	AppConfig.SecurityMode = MY_DEFAULT_WIFI_SECURITY_MODE;
	AppConfig.WepKeyIndex  = MY_DEFAULT_WEP_KEY_INDEX;
   	#if (MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_OPEN)
      memset(AppConfig.SecurityKey, 0x00, sizeof(AppConfig.SecurityKey));
      AppConfig.SecurityKeyLength = 0;
    #elif MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WEP_40
      memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_WEP_KEYS_40, sizeof(MY_DEFAULT_WEP_KEYS_40) - 1);
      AppConfig.SecurityKeyLength = sizeof(MY_DEFAULT_WEP_KEYS_40) - 1;
    #elif MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WEP_104
	  memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_WEP_KEYS_104, sizeof(MY_DEFAULT_WEP_KEYS_104) - 1);
	  AppConfig.SecurityKeyLength = sizeof(MY_DEFAULT_WEP_KEYS_104) - 1;
    #elif (MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WPA_WITH_KEY)       || \
          (MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WPA2_WITH_KEY)      || \
          (MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WPA_AUTO_WITH_KEY)
	  memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_PSK, sizeof(MY_DEFAULT_PSK) - 1);
	  AppConfig.SecurityKeyLength = sizeof(MY_DEFAULT_PSK) - 1;
    #elif (MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WPA_WITH_PASS_PHRASE)     || \
          (MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WPA2_WITH_PASS_PHRASE)    || \
          (MY_DEFAULT_WIFI_SECURITY_MODE == WF_SECURITY_WPA_AUTO_WITH_PASS_PHRASE)
       memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_PSK_PHRASE, sizeof(MY_DEFAULT_PSK_PHRASE) - 1);
       AppConfig.SecurityKeyLength = sizeof(MY_DEFAULT_PSK_PHRASE) - 1;
    #else 
        #error "No security defined"
        #endif /* MY_DEFAULT_WIFI_SECURITY_MODE */


	BYTE c;
		
	SPIFlashReadArray(0x0000, &c, 1);
	if(c == 0x60u)  // 60 is written in the first byte when config is saved initially so if this location is a hex 60 then we know an AppConfig has already been saved.
	{
		SPIFlashReadArray(0x0001, (BYTE*)&AppConfig, sizeof(AppConfig)); //

		if(AppConfig.Flags.bIsDHCPEnabled == 0); //if the user selects fixed IP
		{
			DHCPDisable(0); 
		}
	}
	else
	{
        	if(AppConfig.networkType != WF_ADHOC)   //don't write the default adhoc SSID to flash 
		{
			//otherwise write the default appconfig to flash
			APP_CONFIG CompareAppConfig;
			SPIFlashReadArray(0x0001, (BYTE*)&CompareAppConfig, sizeof(AppConfig)); //read the current Appconfig from flash so that it can be compared 
			//added by DK on 01-Jun-2012
			if(memcmp(&AppConfig, &CompareAppConfig, sizeof(AppConfig) != 0)) 
			{  
				//if they are the same then no reason to write to flash...it can only be written 100K times
				SPIFlashBeginWrite(0x0000);
				SPIFlashWrite(0x60,TRUE);
				SPIFlashWriteArray((BYTE*)&AppConfig, sizeof(AppConfig));
			}
		}
	}

		        
}

BOOL GetSSIDFile(void)
{
	//read the thumb drive to see if a wireless config file is there. this will 
	//replace the ssid and password of the current Appconfig if it is present
	FILE_HANDLE fp;
	BYTE index = 0;
	BOOL firstDelimiter = TRUE;
	BOOL secondDelimiter = TRUE;
	int index1 = 0;
	BYTE ssidInfo[100];
	char ssid[33];
	char password[70];
	char encryptionType;
	int numbytes;
	
	//bob
	const char ssidfile[9] = "ssid.txt\0";	//filename for where the SSID info is stored
	fp = FileOpen((char *)ssidfile, "r"); //go open the file0

	if(fp != NULL)								
	{

		//the SSID file is in the format: SSID/Encrytion type/Password/encryption type/  "/" delimits all fields  
		//SSID is limited to 32 alpha numeric characters
		//Encryption Type can be :
		// 0 for no encryption
		// 1 for WEP 40 (the password must be 10 chars which is 5 hex bytes * 8 bits = 40 bits) 
		// 2 for WEP 104 (the password must be 26 chars which is 13 hex bytes * 8 bits = 104 bits)
		// 8 for WPA Auto with pass Phrase which must be at least 8 and a max of 63 alpha numeric characters
		numbytes = FSfread((char *) &ssidInfo, 1,sizeof(ssidInfo), fp); 
		FileClose(fp);
		//parse SSID in the file and compare it to Appconfig SSID. if they are the same do nothing. If they are different then
		//the SSID file takes priority. Attempt to connect to the new Network. If this is successful then save
		//the info in the Flash. If the info in the file is incorrect the board will crash right here until the SSID info is corrected. 
		//the only way out of this is to hold down the button when resetting. Both the SSID file and the network info in flash will be deleted

		for(index = 0;index < sizeof(ssidInfo);index++)
		{
			if(firstDelimiter)
			{
				if(ssidInfo[index] == '/')
				{
					firstDelimiter = FALSE;
					ssid[index1] = '\0';
					index1 = 0;
					continue;
				}
				else
				{
					ssid[index1] = ssidInfo[index];
				}
				index1++;
			}
			else if(secondDelimiter)
			{
				if(ssidInfo[index] == '/')
				{
					secondDelimiter = FALSE;
					password[index1] = '\0';
					continue;
				}
				else
				{
					password[index1] = ssidInfo[index];
				}
				index1++;
			}
			else
			{
				encryptionType = ssidInfo[index];
				break;
			}
	
				
		}

		strcpy((char *)AppConfig.MySSID,ssid); 
		AppConfig.SsidLength = strlen((char *)AppConfig.MySSID);    
		AppConfig.networkType = WF_INFRASTRUCTURE;
		//Set Security Mode
		switch (encryptionType)
		{
			case '0':  //no security
			strcpy((char *)AppConfig.SecurityKey,password);
			AppConfig.SecurityMode = WF_SECURITY_OPEN;
			memset(AppConfig.SecurityKey, 0x00, sizeof(AppConfig.SecurityKey));
      		AppConfig.SecurityKeyLength = 0;
			break;
			
			case '1':  //WEP 40
			strcpy((char *)AppConfig.SecurityKey,password);
			AppConfig.SecurityMode = WF_SECURITY_WEP_40;
			AppConfig.SecurityKeyLength = 5;
			convertAsciiToHexInPlace((INT8 *)&AppConfig.SecurityKey[0],(UINT8) 5); //because the key is input in hex ascii we must convert
			break;		
			
			case '2':   //WEP 104
			strcpy((char *)AppConfig.SecurityKey,password);
 			AppConfig.SecurityMode = WF_SECURITY_WEP_104;
			AppConfig.SecurityKeyLength = 13;
			convertAsciiToHexInPlace((INT8 *)&AppConfig.SecurityKey[0],(UINT8)13u); //because the key is input in hex ascii we must convert
			break;

			case '7':	//WPA auto with 64 byte ascii key
			memcpy(AppConfig.SecurityKey,password,64);
			AppConfig.SecurityMode = WF_SECURITY_WPA_AUTO_WITH_KEY;
			convertAsciiWPAKeyToHex(AppConfig.SecurityKey);
			memcpy(AppConfig.SecurityKey , HexWPAKey ,32);
			AppConfig.SecurityKeyLength = 32; //strlen(AppConfig.SecurityKey);
			break;

			case '8':	//WPA auto with Pharase Code
			strcpy((char *)AppConfig.SecurityKey,password);
			AppConfig.SecurityMode = WF_SECURITY_WPA_AUTO_WITH_KEY;
			EncryptionInProgress = TRUE;
			getWpaPskKeyFromPassphrase(AppConfig.SecurityKey, AppConfig.MySSID);
			EncryptionInProgress = FALSE;
			memcpy(AppConfig.SecurityKey , HexWPAKey ,32);
			AppConfig.SecurityKeyLength = 32; //strlen(AppConfig.SecurityKey);
			break;
		}	
		while(FSremove((char *)ssidfile) != 0 );
		SaveAppConfig();
		Reset();
		
	 
	}
	return FALSE;
} 



/****************************************************************************
  Function:
    BOOL USB_ApplicationEventHandler( BYTE address, USB_EVENT event,
                void *data, DWORD size )

  Summary:
    This is the application event handler.  It is called when the stack has
    an event that needs to be handled by the application layer rather than
    by the client driver.

  Description:
    This is the application event handler.  It is called when the stack has
    an event that needs to be handled by the application layer rather than
    by the client driver.  If the application is able to handle the event, it
    returns TRUE.  Otherwise, it returns FALSE.

  Precondition:
    None

  Parameters:
    BYTE address    - Address of device where event occurred
    USB_EVENT event - Identifies the event that occured
    void *data      - Pointer to event-specific data
    DWORD size      - Size of the event-specific data

  Return Values:
     TRUE    - The event was handled
    FALSE   - The event was not handled

  Remarks:
    The application may also implement an event handling routine if it
    requires knowledge of events.  To do so, it must implement a routine that
    matches this function signature and define the USB_HOST_APP_EVENT_HANDLER
    macro as the name of that function.
  ***************************************************************************/

BOOL USB_ApplicationEventHandler( BYTE address, USB_EVENT event, void *data, DWORD size )
{
    switch( event ) 
    {
        case EVENT_VBUS_REQUEST_POWER:
            // The data pointer points to a byte that represents the amount of power
            // requested in mA, divided by two.  If the device wants too much power,
            // we reject it.
            return TRUE;

        case EVENT_VBUS_RELEASE_POWER:
            // Turn off Vbus power.
            // The PIC24F with the Explorer 16 cannot turn off Vbus through software.

            //This means that the device was removed
            deviceAttached = FALSE;
            return TRUE;
            break;

        case EVENT_HUB_ATTACH:
            return TRUE;
            break;

        case EVENT_UNSUPPORTED_DEVICE:
            return TRUE;
            break;

        case EVENT_CANNOT_ENUMERATE:
            //UART2PrintString( "\r\n***** USB Error - cannot enumerate device *****\r\n" );
            return TRUE;
            break;

        case EVENT_CLIENT_INIT_ERROR:
            //UART2PrintString( "\r\n***** USB Error - client driver initialization error *****\r\n" );
            return TRUE;
            break;

        case EVENT_OUT_OF_MEMORY:
            //UART2PrintString( "\r\n***** USB Error - out of heap memory *****\r\n" );
            return TRUE;
            break;

        case EVENT_UNSPECIFIED_ERROR:   // This should never be generated.
            //UART2PrintString( "\r\n***** USB Error - unspecified *****\r\n" );
            return TRUE;
            break;

        default:
            break;
    }

    return FALSE;
}


/****************************************************************************
  Function:
    void MonitorMedia( void )

  Description:
    This function detects the USB, SD card/CF card presence. 
    For the USB, SD/CF card this is a Function pointer to the Media Detect Physical Layer function.
    This function calls the background tasks necessary to support USB Host
    operation.  Upon initial insertion of the media, it initializes the file
    system support and reads the volume label.  Upon removal of the media,
    the volume label is marked invalid.

  Precondition:
    None

  Parameters:
    None

  Returns:
    None

  Remarks:
    None
  ***************************************************************************/

void MonitorMedia( void )
{
#ifdef USE_USB_INTERFACE

    BYTE            mediaPresentNow;
    BYTE            mountTries;
    USBTasks();

   // An overcurrent situation is not monitored
    mediaPresentNow = USBHostMSDSCSIMediaDetect();
    if (!mediaPresentNow)
    {
        mediaStatus.cannotInitialize = FALSE;
    }    
    if ((mediaPresentNow != mediaStatus.mediaPresent) && !mediaStatus.cannotInitialize)
    {
        if (mediaPresentNow)
        {
            mountTries = 10;
            while(!FSInit() && --mountTries);
            if (!mountTries)
            {
                mediaStatus.mediaPresent       = FALSE;
                mediaStatus.cannotInitialize   = TRUE;
            }
            else
            {
                mediaStatus.mediaPresent = TRUE;
            }
        }
        else
        {
            mediaStatus.mediaPresent   = FALSE;
        }
    }
#endif
}


/*****************************************************************************
 * FUNCTION: WF_Connect
 *
 * RETURNS:  None
 *
 * PARAMS:   None
 *
 *  NOTES:   Connects to an 802.11 network.  Customize this function as needed 
 *           for your application.
 *****************************************************************************/
 void WF_Connect()
{
    UINT8 ConnectionProfileID;
    UINT8 channelList[] = MY_DEFAULT_CHANNEL_LIST;

    WF_CPCreate(&ConnectionProfileID);
    
	WF_CPSetSsid(ConnectionProfileID, 
                 AppConfig.MySSID, 
                 AppConfig.SsidLength);

    WF_CPSetNetworkType(ConnectionProfileID, AppConfig.networkType);
    
    WF_CASetScanType(MY_DEFAULT_SCAN_TYPE);
       
    WF_CASetChannelList(channelList, sizeof(channelList));
    
    WF_CASetListRetryCount(MY_DEFAULT_LIST_RETRY_COUNT);

    WF_CASetEventNotificationAction(MY_DEFAULT_EVENT_NOTIFICATION_LIST);

    WF_CASetBeaconTimeout(40);

    WF_CPSetSecurity(ConnectionProfileID,
                     AppConfig.SecurityMode,
                     AppConfig.WepKeyIndex,   /* only used if WEP enabled */
                     AppConfig.SecurityKey,
                     AppConfig.SecurityKeyLength);
//bob	int a =0;
    WF_CMConnect(ConnectionProfileID);
}   






void SaveAppConfig(void)
{
	if(AppConfig.networkType != WF_ADHOC) 
	{
		APP_CONFIG CompareAppConfig;
		int AppconfigSize = sizeof(AppConfig);
		SPIFlashReadArray(0x0001, (BYTE*)&CompareAppConfig,sizeof(AppConfig) ); //read the current Appconfig from flash so that it can be compared 
		//added by DK on 01-Jun-2012
		int compare = memcmp(&AppConfig, &CompareAppConfig, AppconfigSize);
		if(compare != 0) 
		{  
			//if they are the same then no reason to write to flash...it can only be written to 100K times
			SPIFlashBeginWrite(0x0000);
			SPIFlashWrite(0x60,TRUE);
			SPIFlashWriteArray((BYTE*)&AppConfig, sizeof(AppConfig));
		}
	}
}




/*****************************************************************************
  Function:
    void ConvertUtcSecToString(INT32 utc, char* time_str)

  Summary:
    Converts a UTC timestamp to a string

  Description:
    This function will convert a UTC timestamp to an RFC-specified
    string format representation of that value.

  Precondition:
    None

  Parameters:
    utc - The UTC timestamp to be converted
    time_str - A string pointing to the buffer that will contain the result.

  Return Values:
    None
  ***************************************************************************/
void ConvertUtcSecToString(DWORD utc, char* time_str)
{
    WORD seconds;
    WORD minutes;
    WORD hours;
    DWORD days;
    WORD year;
    BYTE monthArray[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
    WORD month = 0;
    BYTE buffer[5];
    BYTE counter = 0;
	if(utc > 100000) //added by Don to convert GMT to Local time *** TODO - figure out how to determine Daylight savings time
	{
		int utcConvert =  TimeZoneToUTCConvert[PowerReadings.TimeZone];
		if(PowerReadings.DST)
			utcConvert -= 3600; //add an hour back for DST.
		utc -= utcConvert;
	}
    days = utc / 86400;
    utc -= (days * 86400);
    hours = utc / 3600;
    utc -= ((DWORD)hours * 3600);
    minutes = utc / 60;
    utc -= (minutes * 60);
    seconds = utc;

    year = 1970;
    // This algorithm will iteratively determine how many years have passed
    // There is a mathematical way to determine how many years have passed,
    // but the equation is complicated by the lack of a leap day on years
    // divisible by 100 (except if the year is also divisible by 400)
    while (((year % 4 == 0) && (days >= 366)) || ((year % 4 != 0) && (days >= 365)))
    {
        if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0))
        {
            // It's a Leap Year
            days -= 366;
        }
        else
        {
            // Not Leap Year
            days -= 365;
        }
        year++;
    }
    // If the current year is a leap year, add another day to February
    if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0))
    {
        monthArray[1]++;
    }
    // Determine the current month
    while (days >= monthArray[month])
    {
        days -= monthArray[month];
        month++;
    }
    month++;
    days++;

    // Convert to standard YYYY-MM-DDThh:mm:ss.sTZD form
    uitoa (year, buffer);
    buffer[4] = '-';
    memcpy (time_str, buffer, 5);
    counter += 5;
    uitoa (month, buffer);
    PadBuffer (month, buffer);
    buffer[2] = '-';
    memcpy (time_str + counter, buffer, 3);
    counter += 3;
    ultoa (days, buffer);
    PadBuffer (days, buffer);
    buffer[2] = 'T';
    memcpy (time_str + counter, buffer, 3);
    counter += 3;
    uitoa (hours, buffer);
    PadBuffer (hours, buffer);
    buffer[2] = ':';
    memcpy (time_str + counter, buffer, 3);
    counter += 3;
    uitoa (minutes, buffer);
    PadBuffer (minutes, buffer);
    buffer[2] = ':';
    memcpy (time_str + counter, buffer, 3);
    counter += 3;
    uitoa (seconds, buffer);
    PadBuffer (seconds, buffer);
    buffer[2] = '.';
    memcpy (time_str + counter, buffer, 3);
    counter += 3;
    *(time_str + counter++) = '0';
    *(time_str + counter++) = '0';
    *(time_str + counter++) = '0';
    *(time_str + counter++) = 'Z';
    *(time_str + counter++) = 0;
}


/*****************************************************************************
  Function:
    void PadBuffer (DWORD value, BYTE * buffer)

  Summary:
    Pads a hour/minute/second value to include a leading zero

  Description:
    This function will check a time value to determine if it's a single
    digit value.  If so, it will insert a leading zero.

  Precondition:
    None

  Parameters:
    value - The time value
    buffer - The string to be updated

  Return Values:
    None
  ***************************************************************************/
void PadBuffer (WORD value, BYTE * buffer)
{
    if (value < 10)
    {
        *(buffer + 1) = *buffer;
        *buffer = '0';
    }
}

BOOL SavePowerReadingOnThumbDrive(POWER_READINGS * powerRead)
{
	//char excelHeader[] = "Watt Load A,Watt Load B,Watt Load C,Total A Watt Hours,Total B Watt Hours,Total C Watt Hours,Total Watt Hours,Date,Time\r";
	CSV_STRUCTURE commaSeperatedReadings;
    	FILE_HANDLE fp;
    	BYTE  mediaPresentNow;
	size_t numbytes;
	char logfile[12] = "\0"; //filename where Power Readings are stored in the form of yyyy-mmm.csv
	BYTE day[3] = "\0"; 
	BYTE month[3] = "\0"; 
	BYTE year[5] = "\0";   
	mediaPresentNow = USBHostMSDSCSIMediaDetect();
    	
	if (!mediaPresentNow) //if the thumb drive has been removed
	{
		//strcat(debugSave,"5,");
		return FALSE;     //get out...you can't save to the thumb drive
	
	}
    CSV_CONVERSION(powerRead,&commaSeperatedReadings); //do the power readings structure to comma seperated structure conversion
	strncpy(logfile, time_str,7); //put the year and month in the filename
	strncpy((char *)day, &time_str[8],2); //get the current day of the month
	strncpy((char *)month, &time_str[5],2); //get the current month
	strncpy((char *)year, &time_str[0],4);  //Get the current year
	
	int iBillDay = atoi(PowerReadings.BillDay); //Convert them all
	int iMonth = atoi((char *)month);				//to
	int iYear = atoi((char *)year);					//integer
	int iday = atoi((char *)day);
	if(iYear == 1970)
		return TRUE; //if the UTC time is incorrect then don't write it to the file
	if(iBillDay <= iday && iBillDay != 1) //if the billing period for the current month has completed
	{
		if(iMonth == 12)  // and this is december
		{
		  strncpy((char *)month,"01",2);   // then the next billing period is January
		  iYear++; //of the next year
		  uitoa(iYear,year); //put the year back into a string;
		}
		else
		  {
			iMonth++;   //otherwise just add 1 to the month
			uitoa(iMonth,month); //and put the billing month back into month.
			if(iMonth < 10) 
			  {
				 month[1] = month[0]; //uatoi will make the string "7 " when the month = 07
				 month[0] = 0x30; //so move the first digit over and place a 0 in the first position
			  }
		  }
		  strncpy((char *)logfile,(char *)year,4);
		  logfile[5] = month[0];
		  logfile[6] = month[1];
	} 
	strcat(&logfile[6], ".csv");
	if(strncmp(logfile,PowerReadings.logFileName,7) != 0)   //If the Year and Month have been changed then we must have just changed months or bill periods so clear accumulators
	{
	 	PowerReadings.Accum_A_Reg = 0;				 
		PowerReadings.Accum_B_Reg = 0;			 	
		PowerReadings.Accum_C_Reg = 0;				 	 
		PowerReadings.Accum_Total_Watt_Hour = 0;
		strncpy(PowerReadings.logFileName,logfile,7); //set the new Logfile name in the save area. This can only happen once.
		SaveAccumWattsToFlash();	
	}
	
	fp = FileOpen((char *)logfile, "A"); //go open the file
	//if(writeHeader)					// if this is a new file then write the header for excel 1 time
	  //{
		//numbytes = FSfwrite((char *) excelHeader,1,sizeof(excelHeader), fp);
	//	writeHeader = FALSE;		  
	 // } 
	if(fp == NULL)
	{
		return FALSE; //something failed in the file open
	}
	
	numbytes = FSfwrite(&commaSeperatedReadings, 1,sizeof(CSV_STRUCTURE)-2, fp);
	//strcat(debugSave,"6,");	
	FileClose(fp);
	return TRUE; //file write was successful 
} 







void lcdColor(BYTE color)
{
	LCD_RED 	= color & 0x01;
	LCD_BLUE 	= (color>>1) & 0x01;
	LCD_GREEN 	= (color>>2) & 0x01;
	currentLcdColor = color;
}


void ClearFlash(DWORD beginAddress,DWORD endAddress)
{

		for(Kwh_Address = beginAddress;Kwh_Address < endAddress;Kwh_Address+= 0x1000)   //to erase the flash you only need to be on a 4K boundary
		{	
		
					SPIFlashBeginWrite(Kwh_Address); //set flash to write at address
					SPIFlashWrite(0xFF,TRUE); // write first byte 
			//		sprintf(LCDText,"ADDRESS =%lx",Kwh_Address);
			//		Print_Line_Two((BYTE *)LCDText);
			//		asm("CLRWDT");
				
		}

}

void CSV_CONVERSION(POWER_READINGS * PowerReads,CSV_STRUCTURE * a)
{

	memset(a, 0x20, sizeof(CSV_STRUCTURE));
	a->comma1 = 0x2c;
	a->comma2 = 0x2c;
	a->comma3 = 0x2c;
	a->comma4 = 0x2c;
	a->comma5 = 0x2c;
	a->comma6 = 0x2c;
	a->comma7 = 0x2c;
	a->comma8 = 0x2c;
	a->comma9 = 0x2c;	
	a->comma10 = 0x2c;
	char ttt[2];
	double A_watt_total;
	double B_watt_total;
	double C_watt_total;
	int sscanferr;
	a->CR = 0xd;// carrage return
	//StackStartTime = SNTPGetUTCSeconds();
    ConvertUtcSecToString(PowerReads->UTC_time, (char*) time_str);
	sscanferr=sscanf(time_str,"%10c%1c%8c",(char *)a->date,(char *)ttt,(char *)a->time);
	A_watt_total =(PowerReads->Accum_A_Reg*wh_lsb);
	B_watt_total =(PowerReads->Accum_B_Reg*wh_lsb);
	C_watt_total =(PowerReads->Accum_C_Reg*wh_lsb);
	sprintf(a->Watt_Load_A,"%d",PowerReads->Watt_Load_A);
	sprintf(a->Watt_Load_B,"%d",PowerReads->Watt_Load_B);
	sprintf(a->Watt_Load_C,"%d",PowerReads->Watt_Load_C);
	sprintf(a->Accum_A_Total_Watt_Hour,"%11.1f",A_watt_total);
	sprintf(a->Accum_B_Total_Watt_Hour,"%11.1f",B_watt_total);
	sprintf(a->Accum_C_Total_Watt_Hour,"%11.1f",C_watt_total);
	sprintf(a->Accum_Total_Watt_Hour,"%11.1f" ,PowerReads->Accum_Total_Watt_Hour);
	calculate_Power_Reading_CRC((BYTE*)&a,sizeof(a));
	a->CRC = crc;
}


void calculate_Power_Reading_CRC(BYTE* vData, WORD wLen)
// calculate checksum over (len) bytes starting at (dat)
// returns current crc value at end
{
	unsigned int i;
	for(i=0; i<(wLen-2); ++i) // get crc for all data except the crc itself thus the -2
	{
		crc_calc(*vData);
		*vData++;
	}
	
}

void  getWpaPskKeyFromPassphrase(char * pass, char * ssid)
{
	DWORD state[80];
	DWORD *pstate = &state;
	//long padbyte = 92;
	//long b[5]; 
	int x = 0;
	DWORD zero = 0; 
	DWORD hmac_istate[5];
	DWORD hmac_ostate[5];
	stringtowords(pstate,pass,zero);
	initsha(pstate,hmac_istate,54ul);
	stringtowords(pstate,pass,zero);
	initsha(pstate,hmac_ostate,92ul);
	DWORD i = 0;
	char hash[65];
	memset(hash,0,65);
  	while (strlen(hash) < 64) 
	{
    	/* prepare 20-byte (5-word) output vector */
		//int h = strlen(hash);
    	DWORD u[5] = { 0, 0, 0, 0, 0 };
		DWORD j,a,b,c,d,e,t;
		DWORD * s;
		int k;
    	/* prepare input vector for the first SHA1 update (salt + block number) */
    	i++;
    	stringtowords(&state,ssid, i);
    	/* iterate 4096 times an inner and an outer SHA1 operation */
	    for ( j = 0; j < 2 * 4096; j++) 
		{
		      /* alternate inner and outer SHA1 operations */
		      s = (j & 1) ? &hmac_ostate : &hmac_istate;
		      /* inline the SHA1 update operation */
		      a = *(s+0), b = *(s+1), c = *(s+2), d = *(s+3), e = *(s+4);
		      //t;
		      for (k = 16; k < 80; k++) {
		        t = state[k-3] ^ state[k-8] ^ state[k-14] ^ state[k-16];
		        state[k] = (t<<1) | (t>>31);
		      }
		      for (k = 0; k < 20; k++) 
			  {
		        t = ((a<<5) | (a>>27)) + e + state[k] + 0x5A827999 + ((b&c)|((~b)&d));
		        e = d; d = c; c = (b<<30) | (b>>2); b = a; a = t & 0xffffffff;
		      }
		      for (k = 20; k < 40; k++) 
			  {
		        t = ((a<<5) | (a>>27)) + e + state[k] + 0x6ED9EBA1 + (b^c^d);
		        e = d; d = c; c = (b<<30) | (b>>2); b = a; a = t & 0xffffffff;
		      }
		      for (k = 40; k < 60; k++) 
			  {
		        t = ((a<<5) | (a>>27)) + e + state[k] + 0x8F1BBCDC + ((b&c)|(b&d)|(c&d));
		        e = d; d = c; c = (b<<30) | (b>>2); b = a; a = t & 0xffffffff;
		      }
		      for (k = 60; k < 80; k++) 
			  {
		        t = ((a<<5) | (a>>27)) + e + state[k] + 0xCA62C1D6 + (b^c^d);
		        e = d; d = c; c = (b<<30) | (b>>2); b = a; a = t & 0xffffffff;
		      }
		      /* stuff the SHA1 output back into the input vector */
		      state[0] = (*(s+0) + a) & 0xffffffff;
		      state[1] = (*(s+1) + b) & 0xffffffff;
		      state[2] = (*(s+2) + c) & 0xffffffff;
		      state[3] = (*(s+3) + d) & 0xffffffff;
		      state[4] = (*(s+4) + e) & 0xffffffff;
		      if (j & 1) 
			  {
		      	  /* XOR the result of each complete HMAC-SHA1 operation into u */
				  u[0] ^= state[0]; u[1] ^= state[1]; u[2] ^= state[2]; u[3] ^= state[3]; u[4] ^= state[4];
		      } 
			  else if (j == 0) 
			  {
		        /* pad the new 20-byte input vector for subsequent SHA1 operations */
				state[5] = 0x80000000;
				for (k = 6; k < 15; k++) state[k] = 0;
				state[15] = 8 * (64 + 20);
		      }
	    }
	    /* convert output vector u to hex and append to output string */
	    for (j = 0; j < 5; j++)
	      for (k = 0; k < 8; k++) 
		  {
	        t = (u[j] >> (28 - 4 * k)) & 0x0f;
			hash[x++] += (t < 10) ? (t+48) : (87 + t);
	      }
  }

	hash[64] = 0;
	convertAsciiWPAKeyToHex(hash);
}
	
 
	
void stringtowords(DWORD *  z,char * s,DWORD padi) {
    /* return a 80-word array for later use in the SHA1 code */
    int j = -1, k = 0,i,n;
	DWORD c;
    n = strlen(s);
    for (i = 0; i < 64; i++) 
	{
      c = 0;
      if (i < n) 
	  {
        c = s[i];
      } 
	  else if (padi) 
	  {
        /* add 4-byte PBKDF2 block index and
	    standard padding for the final SHA1 input block */
		if (i == n) c = (padi >> 24) & 0xff;
		else if (i == n + 1) c = (padi >> 16) & 0xff;
		else if (i == n + 2) c = (padi >> 8) & 0xff;
		else if (i == n + 3) c = padi & 0xff;
		else if (i == n + 4) c = 0x80;
      }
      if (k == 0) { j++; *(z+j) = 0; k = 32; }
      k -= 8;
      *(z+j) = *(z+j) | (c << k);
    }
    if (padi) *(z+15) = 8 * (64 + n + 4);

  }



  /* compute the intermediate SHA1 state after processing just
    the 64-byte padded HMAC key */
void initsha(DWORD *  w, DWORD * s,long padbyte) 
{
	DWORD k,t,pw;
	DWORD a,b,c,d,e;
    pw = (padbyte << 24) | (padbyte << 16) | (padbyte << 8) | padbyte;
    for (t = 0; t < 16; t++)
	{ 
		*(w+t) ^= pw;
	}
	*(s+0) = 0x67452301;
    *(s+1) = 0xEFCDAB89;
    *(s+2) = 0x98BADCFE;
	*(s+3) = 0x10325476;
	*(s+4) = 0xC3D2E1F0;
	
	a = *(s+0);
 	b = *(s+1);
 	c = *(s+2);
  	d = *(s+3);
  	e = *(s+4);
    for (k = 16; k < 80; k++) {
      t = *(w+k-3) ^ *(w+k-8) ^ *(w+k-14) ^ *(w+k-16);
      *(w+k) = (t<<1) | (t>>31);
    }

    for (k = 0; k < 20; k++) {
      t = ((a<<5) | (a>>27)) + e + *(w+k) + 0x5A827999 + ((b&c)|((~b)&d));
      e = d; d = c; c = (b<<30) | (b>>2); b = a; a = t & 0xffffffff;
    }
    for (k = 20; k < 40; k++) {
      t = ((a<<5) | (a>>27)) + e + *(w+k) + 0x6ED9EBA1 + (b^c^d);
      e = d; d = c; c = (b<<30) | (b>>2); b = a; a = t & 0xffffffff;
    }
    for (k = 40; k < 60; k++) {
      t = ((a<<5) | (a>>27)) + e + *(w+k) + 0x8F1BBCDC + ((b&c)|(b&d)|(c&d));
      e = d; d = c; c = (b<<30) | (b>>2); b = a; a = t & 0xffffffff;
    }
    for (k = 60; k < 80; k++) 
    {
      t = ((a<<5) | (a>>27)) + e + *(w+k) + 0xCA62C1D6 + (b^c^d);
      e = d; 
	  d = c;
      c = (b<<30) | (b>>2);
      b = a; 
      a = t & 0xffffffff;
    }
    *(s+0) = (*(s+0) + a) & 0xffffffff;
    *(s+1) = (*(s+1) + b) & 0xffffffff;
    *(s+2) = (*(s+2)+ c) & 0xffffffff;
    *(s+3) = (*(s+3) + d) & 0xffffffff;
    *(s+4) = (*(s+4) + e) & 0xffffffff;

}

void convertAsciiWPAKeyToHex(char * hash)
{
	int i,j;
	j=0;
	for(i=0;i< strlen(hash);i+=2)
	{
		BYTE hashHigh =  *(hash+i) < 58 ? *(hash+i) -48 <<4 : *(hash+i) -87 <<4;
		BYTE hashLow =  *(hash+i+1) < 58 ? *(hash+i+1) -48 : *(hash+i+1) -87;
		HexWPAKey[j++] = hashHigh | hashLow;
	}
}
void SaveAccumWattsToFlash()
{
		BOOL accumWritten = FALSE;
writeAgain:
		for(Kwh_Address = saveAccumAreaStart;Kwh_Address < saveAccumAreaEnd;Kwh_Address+= sizeof(PowerReadings)+1)// each saved block is 0x20 bytes long. search until 0xff found within 4kbyte sector
		{		
			SPIFlashReadArray(Kwh_Address, &Block_Busy_Byte, 1); //read first byte of block
			if(Block_Busy_Byte == 0xFF) // see if 0xff
				{	
					SPIFlashBeginWrite(Kwh_Address); //set flash to write at address
					SPIFlashWrite(0x7F,FALSE); // write first byte 
					SPIFlashWriteArray((BYTE *)&PowerReadings,sizeof(PowerReadings) ); //write data 
					accumWritten = TRUE;
					break;
				}
		
		}
		if(!accumWritten)
		{
		  ClearFlash(saveAccumAreaStart,saveAccumAreaEnd);
		  goto writeAgain;
 		}
		  
}



void initPowerReadings() 
{
	PowerReadings.Watt_Load_A = 0;
	PowerReadings.Watt_Load_B = 0;               
	PowerReadings.Watt_Load_C = 0;                
	PowerReadings.Accum_A_Reg = 0;				 
	PowerReadings.Accum_B_Reg = 0;			 	
	PowerReadings.Accum_C_Reg = 0;				 	 
	PowerReadings.Accum_Total_Watt_Hour = 0;		 
	PowerReadings.UTC_time = 0;			        
	PowerReadings.BillDay[0] = 0x30;;
	PowerReadings.BillDay[1] = 0x31;
	memset (PowerReadings.logFileName, 0x00, 7);
	PowerReadings.TimeZone = 1;
}

void FindStartingAccumValue(void)
{
	for(Kwh_Address = saveAccumAreaStart;Kwh_Address < saveAccumAreaEnd;Kwh_Address+= sizeof(PowerReadings)+1)// each saved block is 0x20 bytes long. search until 0xff found within 4kbyte sector
		{		
			SPIFlashReadArray(Kwh_Address, &Block_Busy_Byte, 1); //read the first block
			if(Block_Busy_Byte == 0xFF && Kwh_Address == saveAccumAreaStart) // see if the busy byte is 0xff. if so, the last stored power accum is saved in the previous block if this is the first block	
			{																 //then zero out the power reading area because this is the initial start of the unit
				initPowerReadings();		
			}
			else if(Block_Busy_Byte != 0xFF) // if we've hit the last block then the flash is all written to the thumbdrive
				{
					SPIFlashReadArray(Kwh_Address + 1, (BYTE *)&PowerReadings, sizeof(POWER_READINGS)); //read the last power reading block
					
				}
			else if(Block_Busy_Byte == 0xFF)
				break;    
		}

}


BOOL SaveCalvaluesOnThumbDrive()
{
  	FILE_HANDLE fp;
    BYTE  mediaPresentNow;
	size_t numbytes;
	char logfile[13] = "Cal.txt" "\0"; //filename where Cal Values are stored.
   	mediaPresentNow = USBHostMSDSCSIMediaDetect();
    	
	if (!mediaPresentNow) //if the thumb drive has been removed
		return FALSE;     //get out...you can't save to the thumb drive

	Load_Cal_Structure(); //do the power readings structure to comma seperated structure conversion
	fp = FileOpen((char *)logfile, "W"); //go open the file

	if(fp == NULL)
	{
		return FALSE; //something failed in the file open
	}

	numbytes = FSfwrite(&CalValues, 1,sizeof(CALIBRATION_STRUCTURE)-2, fp); //-2 = int crc
	FileClose(fp);
	return TRUE; //file write was successful 
} 


void Load_Cal_Structure()
{

	int a;
	int b;
	


	a = (Get_Ade_Reg(0x23));
	b = a;
	a = a<< 8 ;
	a = 0xffff & a;
	sprintf(CalValues.GAIN,"0x%04x",a);
	a=Get_Two_Reg(0x2D);
	a = 0xfff & a;
	sprintf(CalValues.AVARG,"0x%04x",a);
	a=Get_Two_Reg(0x2E);
	a = 0xfff & a;
	sprintf(CalValues.BVARG,"0x%04x",a);
	a=Get_Two_Reg(0x2F);
	a = 0xfff & a;
	sprintf(CalValues.CVARG,"0x%04x",a);

	a=Get_Two_Reg(0x33);
	a = 0xfff & a;
	sprintf(CalValues.AVRMSOS,"0x%04x",a);
	a=Get_Two_Reg(0x34);
	a = 0xfff & a;
	sprintf(CalValues.BVRMSOS,"0x%04x",a);
	a=Get_Two_Reg(0x35);
	a = 0xfff & a;
	sprintf(CalValues.CVRMSOS,"0x%04x",a);

	a=Get_Two_Reg(0x36);
	a = 0xfff & a;
	sprintf(CalValues.AIRMSOS,"0x%04x",a);
	a=Get_Two_Reg(0x37);
	a = 0xfff & a;
	sprintf(CalValues.BIRMSOS,"0x%04x",a);
	a=Get_Two_Reg(0x38);
	a = 0xfff & a;
	sprintf(CalValues.CIRMSOS,"0x%04x",a);

	a=Get_Two_Reg(0x2A);
	a = 0xfff & a;
	sprintf(CalValues.AWG,"0x%04x",a);
	a=Get_Two_Reg(0x2B);
	a = 0xfff & a;
	sprintf(CalValues.BWG,"0x%04x",a);
	a=Get_Two_Reg(0x2C);
	a = 0xfff & a;
	sprintf(CalValues.CWG,"0x%04x",a);

	a=Get_Two_Reg(0x30);
	a = 0xfff & a;
	sprintf(CalValues.AVAG,"0x%04x",a);
	a=Get_Two_Reg(0x31);
	a = 0xfff & a;
	sprintf(CalValues.BVAG,"0x%04x",a);
	a=Get_Two_Reg(0x32);
	a = 0xfff & a;
	sprintf(CalValues.CVAG,"0x%04x",a);


	
	a = (Get_Ade_Reg(0x3F));
	b = a;
	a = a<< 8 ;
	a = 0x7fff & a;
	sprintf(CalValues.APHCAL,"0x%04x",a);
	a = (Get_Ade_Reg(0x40));
	b = a;
	a = a<< 8 ;
	a = 0x7fff & a;
	sprintf(CalValues.BPHCAL,"0x%04x",a);
	a = (Get_Ade_Reg(0x41));
	b = a;
	a = a<< 8 ;
	a = 0x7fff & a;
	sprintf(CalValues.CPHCAL,"0x%04x",a);


	a=Get_Two_Reg(0x39);
	a = 0xfff & a;
	sprintf(CalValues.AWATTOS,"0x%04x",a);
	a=Get_Two_Reg(0x3A);
	a = 0xfff & a;
	sprintf(CalValues.BWATTOS,"0x%04x",a);
	a=Get_Two_Reg(0x3B);
	a = 0xfff & a;
	sprintf(CalValues.CWATTOS,"0x%04x",a);


	sprintf(CalValues.WH_LSB,"%.8f",wh_lsb);
	sprintf(CalValues.VA_LSB,"%.8f",Avolt_lsb);
	sprintf(CalValues.VB_LSB,"%.8f",Bvolt_lsb);
	sprintf(CalValues.VC_LSB,"%.8f",Cvolt_lsb);
	sprintf(CalValues.IA_LSB,"%.8f",Aamp_LSB);
	sprintf(CalValues.IB_LSB,"%.8f",Bamp_LSB);
	sprintf(CalValues.IC_LSB,"%.8f",Camp_LSB);
	CalValues.CR1=0X0d;CalValues.LF1=0X0a;
	CalValues.CR2=0X0d;CalValues.LF2=0X0a;
	CalValues.CR3=0X0d;CalValues.LF3=0X0a;
	CalValues.CR4=0X0d;CalValues.LF4=0X0a;
	CalValues.CR5=0X0d;CalValues.LF5=0X0a;
	CalValues.CR6=0X0d;CalValues.LF6=0X0a;
	CalValues.CR7=0X0d;CalValues.LF7=0X0a;
	CalValues.CR8=0X0d;CalValues.LF8=0X0a;
	CalValues.CR9=0X0d;CalValues.LF9=0X0a;
	CalValues.CR10=0X0d;CalValues.LF10=0X0a;
	CalValues.CR11=0X0d;CalValues.LF11=0X0a;
	CalValues.CR12=0X0d;CalValues.LF12=0X0a;
	CalValues.CR13=0X0d;CalValues.LF13=0X0a;
	CalValues.CR14=0X0d;CalValues.LF14=0X0a;
	CalValues.CR15=0X0d;CalValues.LF15=0X0a;
	CalValues.CR16=0X0d;CalValues.LF16=0X0a;
	CalValues.CR17=0X0d;CalValues.LF17=0X0a;
	CalValues.CR18=0X0d;CalValues.LF18=0X0a;
	CalValues.CR19=0X0d;CalValues.LF19=0X0a;
	CalValues.CR20=0X0d;CalValues.LF20=0X0a;
	CalValues.CR21=0X0d;CalValues.LF21=0X0a;
	CalValues.CR22=0X0d;CalValues.LF22=0X0a;
	CalValues.CR23=0X0d;CalValues.LF23=0X0a;
	CalValues.CR24=0X0d;CalValues.LF24=0X0a;
	CalValues.CR25=0X0d;CalValues.LF25=0X0a;
	CalValues.CR26=0X0d;CalValues.LF26=0X0a;
	CalValues.CR27=0X0d;CalValues.LF27=0X0a;
	CalValues.CR28=0X0d;CalValues.LF28=0X0a;
	CalValues.CR29=0X0d;CalValues.LF29=0X0a;
	
}

BOOL GetCALFile()
{
	//read the thumb drive to see if CAL.TXT file present.
	FILE_HANDLE fp;
	int numbytes;


	const char CALFILE[8] = "cal.txt\0";	//filename for where the cal info is stored
	fp = FileOpen((char *)CALFILE, "r"); //go open the file0

	if(fp != NULL)	// found file							
	{
		
		numbytes = FSfread((char *) &CalValues, 1,sizeof(CalValues), fp); 
		FileClose(fp);
		return TRUE;
		
	}

	return FALSE;
} 


void Load_Cal_Values()
{
	char *end;
	char def[] = "0x001f";
	int a;
	
	
	a = strtol(CalValues.GAIN, &end, 16);
	Put_Two_Reg(0x23,a);



	a = strtol(CalValues.AVARG, &end, 16);
	Put_Two_Reg(0x2D,a);
	a = strtol(CalValues.BVARG, &end, 16);
	Put_Two_Reg(0x2E,a);
	a = strtol(CalValues.CVARG, &end, 16);
	Put_Two_Reg(0x2F,a);

	
	a = strtol(CalValues.AVRMSOS, &end, 16);
	Put_Two_Reg(0x33,a);
	a = strtol(CalValues.BVRMSOS, &end, 16);
	Put_Two_Reg(0x34,a);
	a = strtol(CalValues.CVRMSOS, &end, 16);
	Put_Two_Reg(0x35,a);

	a = strtol(CalValues.AIRMSOS, &end, 16);
	Put_Two_Reg(0x36,a);
	a = strtol(CalValues.BIRMSOS, &end, 16);
	Put_Two_Reg(0x37,a);
	a = strtol(CalValues.CIRMSOS, &end, 16);
	Put_Two_Reg(0x38,a);

	a = strtol(CalValues.AWG, &end, 16);
	Put_Two_Reg(0x2A,a);
	a = strtol(CalValues.BWG, &end, 16);
	Put_Two_Reg(0x2B,a);
	a = strtol(CalValues.CWG, &end, 16);
	Put_Two_Reg(0x2C,a);

	a = strtol(CalValues.AVAG, &end, 16);
	Put_Two_Reg(0x30,a);
	a = strtol(CalValues.BVAG, &end, 16);
	Put_Two_Reg(0x31,a);
	a = strtol(CalValues.CVAG, &end, 16);
	Put_Two_Reg(0x32,a);

	a = strtol(CalValues.APHCAL, &end, 16);
	Put_Two_Reg(0x3F,a);
	a = strtol(CalValues.BPHCAL, &end, 16);
	Put_Two_Reg(0x40,a);
	a = strtol(CalValues.CPHCAL, &end, 16);
	Put_Two_Reg(0x41,a);

	a = strtol(CalValues.AWATTOS, &end, 16);
	Put_Two_Reg(0x39,a);
	a = strtol(CalValues.BWATTOS, &end, 16);
	Put_Two_Reg(0x3A,a);
	a = strtol(CalValues.CWATTOS, &end, 16);
	Put_Two_Reg(0x3B,a);


	wh_lsb = strtod(CalValues.WH_LSB, &end);




	Avolt_lsb = strtod(CalValues.VA_LSB, &end);
	Bvolt_lsb = strtod(CalValues.VB_LSB, &end);
	Cvolt_lsb = strtod(CalValues.VC_LSB, &end);

	Aamp_LSB = strtod(CalValues.IA_LSB, &end);
	Bamp_LSB = strtod(CalValues.IB_LSB, &end);
	Camp_LSB = strtod(CalValues.IC_LSB, &end);


	


}
	 	

